#include <stddef.h>
#include <string.h>
#include <avr/io.h>

#include "serial.h"

#define MAX_BUFFER	16

char *digits="0123456789ABCDEF";
int base=10;
unsigned int number=0,op1,op2;
char buffer[MAX_BUFFER+1];
void *next;

int main(void)
{
buffer[MAX_BUFFER]='\0';

goto start;

number_get:
if(base>strlen(digits)) goto *next;
number=0;
_number_get:
char c=serial_get();
char *f=strchr(digits,c);
int pos=f?f-digits:-1;
if(f==NULL || pos>=base) goto *next;
number *= base;
number += pos;
serial_put(c);
goto _number_get;

number_put:
if(base>strlen(digits)) goto *next;
char *p=buffer+MAX_BUFFER;
unsigned int copy=number;
_number_put:
int digit=copy%base;
*--p=digits[digit];
copy /= base;
if(copy && p>buffer) goto _number_put;
serial_print(p);
goto *next;

start:
serial_init(9600);
serial_print("Addition Calculator\n");
goto read_first_number;

read_first_number:
serial_print("first number: ");
next=&&read_second_number;
goto number_get;

read_second_number:
op1=number;
serial_print("\nsecond number: ");
next=&&make_addition;
goto number_get;

make_addition:
op2=number;
number=op1+op2;
serial_print("\naddition: ");
next=&&end;
goto number_put;

end:
serial_print("\n");

return 0;
}

// Exercice: ask user for base and operation to compute
// Exercice: handle negative numbers
