#include <stddef.h>
#include <string.h>
#include <avr/io.h>

#include "serial.h"

#define BASE		10

char *digits="0123456789ABCDEF";

int number_get(int base){
if(base>strlen(digits)) return 0;
int number=0;
while(1){
  char c=serial_get();
  char *f=strchr(digits,c);
  int pos=f?f-digits:-1;
  if(f==NULL || pos>=base) break;
  number *= base;
  number += pos;
  serial_put(c);
  }
return number;
}

void number_put(unsigned int number,int base){
if(base>strlen(digits)) return;
if(number){
  int digit=number%base;
  number_put(number/base,base);
  serial_put(digits[digit]);
  }
return;
}

int main(void)
{
serial_init(9600);
serial_print("Addition Calculator\n");
serial_print("first number: ");
unsigned int op1=number_get(BASE);
serial_print("\nsecond number: ");
unsigned int op2=number_get(BASE);
unsigned int result=op1+op2;
serial_print("\naddition: ");
number_put(result,BASE);
serial_print("\n");
return 0;
}

// Exercice: ask user for base and operation to compute
// Exercice: handle negative numbers
