#include <stdio.h>
#include <avr/io.h>
#include <util/delay.h>

#include "serial.h"

#define SFTSER_DDR	DDRB
#define SFTSER_PORT	PORTB
#define SFTSER_PIN	PB0
#define SFTCLK_DDR	DDRD
#define SFTCLK_PORT	PORTD
#define SFTCLK_PIN	PD7
#define SFTLTC_DDR	DDRD
#define SFTLTC_PORT	PORTD
#define SFTLTC_PIN	PD4

unsigned char digits[]={0xfc,0x60,0xda,0xf2,0x66,0xb6,0xbe,0xe0,0xfe,0xe6,0xee,0x3e,0x9c,0x7a,0x9e,0x8e};

void shift_init() {
//output
SFTSER_DDR |= (1 << SFTSER_PIN);
SFTCLK_DDR |= (1 << SFTCLK_PIN);
SFTLTC_DDR |= (1 << SFTLTC_PIN);
//low
SFTSER_PORT &= ~(1 << SFTSER_PIN);
SFTCLK_PORT &= ~(1 << SFTCLK_PIN);
SFTLTC_PORT &= ~(1 << SFTLTC_PIN);
}

void shift_set(unsigned char b1,unsigned char b2) {
SFTLTC_PORT &= ~(1 << SFTLTC_PIN);
for(int i=0; i<2; i++){
  unsigned char b=(i==0)?b1:b2;
  for(int j=0; j<8; j++){
    SFTCLK_PORT &= ~(1 << SFTCLK_PIN);
    unsigned char val=(b&(1<<j))?1:0;
    SFTSER_PORT |= (val << SFTSER_PIN);
    SFTCLK_PORT |= (1 << SFTCLK_PIN);
    SFTSER_PORT &= ~(1 << SFTSER_PIN);
    }
  }
SFTLTC_PORT |= (1 << SFTLTC_PIN);
}

int main(void)
{
init_printf();
shift_init();

while(1){
  DDRB=(DDRB&0xc3)|0x3c;
  DDRD |= (1<<PD6)|(1<<PD5);
  DDRB |= (1<<PB1);
  DDRC |= (1<<PC5);
  
  int i;
  for(i=0;i<0x10;i++){
    shift_set(~digits[i],0x10);
    PORTB=(PORTB&0xc3)|(((~i)&0x0f)<<2);
    if(i&0x01) PORTD |= (1<<PD5); else PORTD &= ~(1<<PD5);
    if(i&0x02) PORTD |= (1<<PD6); else PORTD &= ~(1<<PD6);
    if(i&0x04) PORTB |= (1<<PB1); else PORTB &= ~(1<<PB1);
    if(i&0x08) PORTC |= (1<<PC5); else PORTC &= ~(1<<PC5);
    _delay_ms(1000);
    }
  }

return 0;
}
