#include <stddef.h>
#include <string.h>
#include <avr/io.h>

#include "serial.h"

#define MAX_BUFFER	16

#define getProgramCounter(x)		{ asm volatile ( "rcall . \n\t pop r16 \n\t pop r17 \n\t mov %B0, r16 \n\t mov %A0, r17" : "=a" (x) : ); x--; x *= 2; }

char *digits="0123456789ABCDEF";
int base=10;
unsigned int number=0;
unsigned int save=0;
char buffer[MAX_BUFFER+1];
void *next;

int main(void)
{
buffer[MAX_BUFFER]='\0';

goto start;

number_put:
if(base>strlen(digits)) goto *next;
char *p=buffer+MAX_BUFFER;
unsigned int copy=number;
_number_put:
int digit=copy%base;
*--p=digits[digit];
copy /= base;
if(copy && p>buffer) goto _number_put;
serial_print(p);
goto *next;

start:
getProgramCounter(save); 

serial_init(9600);
serial_print("Understanding Program Counter!\n");
base=16;
goto print_start_label;

print_start_label:
number=2*(unsigned int)&&start;
next=&&print_start_PC;
goto number_put;

print_start_PC:
serial_print("\n");
number=save;
next=&&print_proc;
goto number_put;

print_proc:
serial_print("\n");
number=2*(unsigned int)&&number_put;
next=&&print_end;
goto number_put;

print_end:
serial_print("\n");
number=2*(unsigned int)&&end;
next=&&end;
goto number_put;

end:
serial_print("\n");

return 0;
}
