/** Functions for serial port **/

#include <avr/io.h>

#include "serial.h"

void serial_init(int speed){
/* Set baud rate */
UBRR0 = F_CPU/(((unsigned long int)speed)<<4)-1;

/* Enable transmitter & receiver */
UCSR0B = (1<<TXEN0 | 1<<RXEN0);

/* Set 8 bits character and 1 stop bit */
UCSR0C = (1<<UCSZ01 | 1<<UCSZ00);

/* Set off UART baud doubler */
UCSR0A &= ~(1 << U2X0);
}

void serial_put(char c){
loop_until_bit_is_set(UCSR0A, UDRE0);
UDR0 = c;
}

char serial_get(void){
loop_until_bit_is_set(UCSR0A, RXC0);
return UDR0;
}

void serial_print(char *s){
for(;*s;s++){
  if(*s=='\n') serial_put('\r');
  serial_put(*s);
  }
}
