#include <stddef.h>
#include <string.h>
#include <avr/io.h>

#include "serial.h"

#define MAX_BUFFER	16

static char *digits="0123456789ABCDEF";

void number_put(unsigned int number,int base){
char buffer[MAX_BUFFER+1];
buffer[MAX_BUFFER]='\0';
if(base>strlen(digits)) return;
char *p=buffer+MAX_BUFFER;
unsigned int copy=number;
do{
  int digit=copy%base;
  *--p=digits[digit];
  copy /= base;
  } while(copy && p>buffer);
serial_print(p);
return;
}

void first_proc(int a){
serial_print("\nfirst function a parameter: ");
number_put(a,10);
serial_print("\nSP in first function: ");
number_put(SP,16);
if(a>0) first_proc(a-1);
return;
}

struct big{
  long int a,b,c,d,e,f;
  };

void second_proc(struct big b){
serial_print("\nSP in second function: ");
number_put(SP,16);
return;
}

int main(void)
{
serial_init(9600);
serial_print("\n\n\nUnderstanding Stack Pointer!");
serial_print("\nSP at main begin: ");
number_put(SP,16);
first_proc(0);
struct big param;
second_proc(param);
first_proc(5);
serial_print("\nSP at main end: ");
number_put(SP,16);
serial_print("\n");
return 0;
}
