#include <string.h>
#include <avr/wdt.h>

#include "serial.h"

#define MAX_BUFFER	16
#define BASE		16
#define BAUDS		9600
#define LED		PB5
#define DELAY		50

static char *digits="0123456789ABCDEF";
volatile int enigma=1;

void number_put(unsigned int number,int base){
char buffer[MAX_BUFFER+1];
buffer[MAX_BUFFER]='\0';
if(base>strlen(digits)) return;
char *p=buffer+MAX_BUFFER;
unsigned int copy=number;
do{
  int digit=copy%base;
  *--p=digits[digit];
  copy /= base;
  } while(copy && p>buffer);
serial_print(p);
return;
}

// Someone has not understood stack concept
void blink(void){
PORTB ^= (1 << LED);
serial_print("Value of stack pointer (SP) is ");
number_put(SP,BASE);
serial_print("\n");
wdt_reset();
if(enigma) blink();
}

int main(void)
{
serial_init(BAUDS);
wdt_enable(WDTO_2S); 
DDRB |= (1 << LED);
PORTB &= ~(1 << LED);
blink();
return 0;
}
